#version 460 core

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in vec4 kolorTeseToGeom[]; 

out vec4 kolorGeomToFrag;

uniform vec3 srodekSfery;
uniform float promienSfery;

const mat4 macierzJednostkowa = mat4(1.0);
uniform mat4 macierzSwiata = macierzJednostkowa;
uniform mat4 macierzWidoku = macierzJednostkowa;
uniform mat4 macierzRzutowania = macierzJednostkowa;
uniform mat4 macierzNormalnych = macierzJednostkowa;
mat4 macierzMVP = macierzRzutowania * macierzWidoku * macierzSwiata;

out vec2 wspTeksturGeomToFrag; //////////////
const float PI = 3.14159265358979323846;

void main()
{
	for (int i = 0; i < 3; i++)
	{
		vec3 A = srodekSfery;
		vec4 B = gl_in[i].gl_Position;
		vec4 kierunekPrzesuniecia = B - vec4(A, 1);

		vec4 wektorPrzesuniecia = normalize(kierunekPrzesuniecia) * promienSfery;

		float phi = atan(B.y, B.x); //////////////////
		if (phi < 0) /////////////
			phi = 2 * PI + phi; /////////////
		float theta = acos(B.z / length(B.xyz)); ////////////////////
		wspTeksturGeomToFrag.s = (1.0 - phi / 2.0 / PI); //////////////////////////////
		wspTeksturGeomToFrag.t = (theta / PI); //////////////////////

		gl_Position = macierzMVP * (vec4(srodekSfery, 1) + vec4(wektorPrzesuniecia));

		kolorGeomToFrag = kolorTeseToGeom[i];

		EmitVertex();
	}

	EndPrimitive();
}

